﻿/// <reference name="MicrosoftAjax.js"/>
Type.registerNamespace ("Books.Publishers");
Books.Publishers.Publisher = function(name, city) {
  Books.Publishers.Publisher.initializeBase(this, [name]);
  this._name = name;
  this._city = city;
  this._editors = [];
  
  this._events = new Sys.EventHandlerList();
}

Books.Publishers.Publisher.prototype = {
  get_name: function() {
    return this._name;
  },
  set_name: function(value) {
    this._name = value;
  },
  get_city: function() {
    return this._city;
  },
  set_city: function(value) {
    this._city = value;
  },

  toString: function() {
    return this._getLocation();
  },

  getLocation: function() {
    return this._name + " w mieście " + this._city; 
  },
  
  get_editors: function() {
    return this._editors;
  },
  
  addEditor: function(editor) {
    Array.add(this._editors, editor);
    var handler = this._events.getHandler("editorAdded");
    if (handler != null) {
        var args = new Books.Publishers.NumberOfEditorsEventArgs(this._editors.length); 
        handler (this, args);
    }
  },
  
  add_editorAdded: function(handler) {
    this._events.addHandler("editorAdded", handler);
  },
  remove_editorAdded: function(handler) {
    this._events.removeHandler("editorAdded", handler);
  }
}
Books.Publishers.Publisher.registerClass("Books.Publishers.Publisher");

Books.Publishers.NumberOfEditorsEventArgs = function(numberOfEditors) {
    this._numberOfEditors = numberOfEditors;
}
Books.Publishers.NumberOfEditorsEventArgs.prototype = {
    get_numberOfEditors: function() { 
        return this._numberOfEditors; 
    }
}
Books.Publishers.NumberOfEditorsEventArgs.registerClass("Books.Publishers.NumberOfEditorsEventArgs", Sys.EventArgs);

    function editorAddedHandler(sender, args) {
        alert ("Bieżąca liczba redaktorów: " + args.get_numberOfEditors());
    }
    
    var pub = new Books.Publishers.Publisher("A&W","Boston");
    pub.add_editorAdded(editorAddedHandler);
    pub.addEditor("Tomek");
    pub.addEditor("Marek");

